import { Phone, MessageCircle, Mail } from 'lucide-react';
import { useFBOAdmin } from '@/context/FBOAdminContext';

export default function FBOFixedContact() {
  const { contact, theme } = useFBOAdmin();

  return (
    <div className="fixed bottom-6 left-6 z-50">
      <div 
        className="p-4 rounded-2xl shadow-lg"
        style={{ backgroundColor: theme.cardBackground }}
      >
        <p 
          className="text-sm font-medium mb-3"
          style={{ color: theme.textColor }}
        >
          Contact FBO
        </p>
        
        <div className="flex gap-2">
          <a
            href={`tel:${contact.phone}`}
            className="w-10 h-10 rounded-full flex items-center justify-center text-white transition-transform hover:scale-110"
            style={{ backgroundColor: theme.primaryColor }}
            title="Appeler"
          >
            <Phone className="w-5 h-5" />
          </a>
          
          <a
            href={`https://wa.me/${contact.whatsapp?.replace(/\D/g, '')}`}
            target="_blank"
            rel="noopener noreferrer"
            className="w-10 h-10 rounded-full flex items-center justify-center text-white transition-transform hover:scale-110"
            style={{ backgroundColor: '#25D366' }}
            title="WhatsApp"
          >
            <MessageCircle className="w-5 h-5" />
          </a>
          
          <a
            href={`mailto:${contact.email}`}
            className="w-10 h-10 rounded-full flex items-center justify-center text-white transition-transform hover:scale-110"
            style={{ backgroundColor: '#EA4335' }}
            title="Email"
          >
            <Mail className="w-5 h-5" />
          </a>
        </div>
      </div>
    </div>
  );
}
