import { StrictMode } from 'react';
import { createRoot } from 'react-dom/client';
import { BrowserRouter as Router, Routes, Route, Navigate } from 'react-router-dom';
import { I18nextProvider } from 'react-i18next';
import i18n from '@/i18n';

// Contexts
import { ContentProvider } from '@/context/ContentContext';
import { AuthProvider } from '@/context/AuthContext';
import { SectionsProvider } from '@/context/SectionsContext';
import { FBOAdminProvider } from '@/context/FBOAdminContext';

// Pages
import LoginPage from '@/pages/LoginPage';
import AdminPanel from '@/pages/AdminPanel';

// Styles
import '@/index.css';

// Admin App component
function AdminApp() {
  return (
    <I18nextProvider i18n={i18n}>
      <ContentProvider>
        <SectionsProvider>
          <FBOAdminProvider>
            <AuthProvider>
              <Router basename="/admin.html">
                <Routes>
                  <Route path="/" element={<LoginPage />} />
                  <Route path="/login" element={<LoginPage />} />
                  <Route path="/dashboard" element={<AdminPanel />} />
                  <Route path="/*" element={<AdminPanel />} />
                </Routes>
              </Router>
            </AuthProvider>
          </FBOAdminProvider>
        </SectionsProvider>
      </ContentProvider>
    </I18nextProvider>
  );
}

// Render
const rootElement = document.getElementById('root');
if (rootElement) {
  createRoot(rootElement).render(
    <StrictMode>
      <AdminApp />
    </StrictMode>
  );
}
