# ZLO Platform - API Documentation

## Overview

RESTful API for ZLO Technologies SaaS Platform. Base URL: `/api/`

## Authentication

The API uses JWT (JSON Web Token) authentication for protected endpoints.

### Login
```http
POST /api/auth/login
Content-Type: application/json

{
    "email": "admin@zlotech.net",
    "password": "admin123"
}
```

**Response:**
```json
{
    "user": {
        "id": 1,
        "name": "Administrator",
        "email": "admin@zlotech.net",
        "role": "super_admin"
    },
    "access_token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9...",
    "refresh_token": "abc123...",
    "expires_in": 7200
}
```

### Using the Token

Include the token in the Authorization header:
```http
Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9...
```

---

## Public Endpoints

### Health Check
```http
GET /api/health
```

### Solutions

#### List Solutions
```http
GET /api/solutions
```

**Query Parameters:**
- `page` - Page number (default: 1)
- `limit` - Items per page (default: 10)
- `featured` - Filter by featured (true/false)

#### Get Single Solution
```http
GET /api/solutions/{id}
GET /api/solutions/slug/{slug}
```

#### Get Featured Solutions
```http
GET /api/solutions/featured
```

#### Get Solution Stats
```http
GET /api/solutions/stats
```

### Blog

#### List Posts
```http
GET /api/blog/posts
```

**Query Parameters:**
- `page` - Page number (default: 1)
- `limit` - Items per page (default: 10)
- `category` - Filter by category slug
- `search` - Search query

#### Get Single Post
```http
GET /api/blog/posts/{slug}
```

#### Get Categories
```http
GET /api/blog/categories
```

### Case Studies

#### List Case Studies
```http
GET /api/case-studies
```

**Query Parameters:**
- `page` - Page number
- `limit` - Items per page
- `industry` - Filter by industry slug
- `solution` - Filter by solution slug

#### Get Single Case Study
```http
GET /api/case-studies/{slug}
```

#### Get Featured Case Studies
```http
GET /api/case-studies/featured
```

#### Get Industries
```http
GET /api/case-studies/industries
```

### Pages

#### List Pages
```http
GET /api/pages
```

#### Get Page by Slug
```http
GET /api/pages/slug/{slug}
```

#### Get Menu Pages
```http
GET /api/pages/menu
```

### Search

#### Global Search
```http
GET /api/search?q={query}&type={type}&limit={limit}
```

**Query Parameters:**
- `q` - Search query (required, min 2 characters)
- `type` - Filter by type: all, solutions, blog, pages, case-studies, faqs
- `limit` - Maximum results (default: 10)

#### Search Suggestions
```http
GET /api/search/suggestions?q={query}&limit={limit}
```

#### Popular Searches
```http
GET /api/search/popular
```

### Contact

#### Submit Contact Form
```http
POST /api/contact/submit
Content-Type: application/json

{
    "name": "John Doe",
    "email": "john@example.com",
    "subject": "Inquiry",
    "message": "Hello, I would like to..."
}
```

### Leads

#### Create Lead
```http
POST /api/leads
Content-Type: application/json

{
    "first_name": "John",
    "last_name": "Doe",
    "email": "john@example.com",
    "company": "Acme Inc",
    "phone": "+1234567890",
    "interest_solution_id": 1,
    "message": "Interested in your services"
}
```

### Newsletter

#### Subscribe
```http
POST /api/newsletter/subscribe
Content-Type: application/json

{
    "email": "user@example.com",
    "source": "website"
}
```

#### Unsubscribe
```http
POST /api/newsletter/unsubscribe
Content-Type: application/json

{
    "email": "user@example.com"
}
```

### Settings

#### Get Public Settings
```http
GET /api/settings/public
```

#### Get SEO Defaults
```http
GET /api/settings/seo
```

#### Get Contact Info
```http
GET /api/settings/contact
```

#### Get Social Links
```http
GET /api/settings/social
```

### Analytics

#### Track Page View
```http
POST /api/analytics/track
Content-Type: application/json

{
    "page": "/solutions",
    "page_type": "solution",
    "visitor_id": "abc123",
    "session_id": "xyz789",
    "referrer": "https://google.com",
    "utm_source": "google",
    "utm_medium": "cpc",
    "utm_campaign": "summer2024"
}
```

---

## Protected Endpoints (Admin)

All protected endpoints require a valid JWT token in the Authorization header.

### Authentication

#### Logout
```http
POST /api/auth/logout
Authorization: Bearer {token}
```

#### Refresh Token
```http
POST /api/auth/refresh
Content-Type: application/json

{
    "refresh_token": "abc123..."
}
```

#### Get Current User
```http
GET /api/me
Authorization: Bearer {token}
```

#### Change Password
```http
POST /api/change-password
Authorization: Bearer {token}
Content-Type: application/json

{
    "current_password": "oldpassword",
    "new_password": "newpassword"
}
```

### Solutions (Admin)

#### Create Solution
```http
POST /api/solutions
Authorization: Bearer {token}
Content-Type: application/json

{
    "title": "New Solution",
    "short_description": "Description...",
    "full_description": "Full description...",
    "icon": "fa-icon",
    "featured": true,
    "status": "active"
}
```

#### Update Solution
```http
PUT /api/solutions/{id}
Authorization: Bearer {token}
Content-Type: application/json

{
    "title": "Updated Title",
    "status": "active"
}
```

#### Delete Solution
```http
DELETE /api/solutions/{id}
Authorization: Bearer {token}
```

### Blog (Admin)

#### Create Post
```http
POST /api/blog/posts
Authorization: Bearer {token}
Content-Type: application/json

{
    "title": "New Blog Post",
    "excerpt": "Short excerpt...",
    "content": "Full content...",
    "category_id": 1,
    "tags": ["tech", "innovation"],
    "status": "published",
    "featured": false
}
```

#### Update Post
```http
PUT /api/blog/posts/{id}
Authorization: Bearer {token}
Content-Type: application/json
```

#### Delete Post
```http
DELETE /api/blog/posts/{id}
Authorization: Bearer {token}
```

### Leads (Admin)

#### List Leads
```http
GET /api/leads
Authorization: Bearer {token}
```

**Query Parameters:**
- `page` - Page number
- `limit` - Items per page
- `status` - Filter by status
- `search` - Search query

#### Get Single Lead
```http
GET /api/leads/{id}
Authorization: Bearer {token}
```

#### Update Lead
```http
PUT /api/leads/{id}
Authorization: Bearer {token}
Content-Type: application/json

{
    "status": "qualified",
    "score": 85,
    "notes": "Hot lead, follow up soon"
}
```

#### Assign Lead
```http
POST /api/leads/{id}/assign
Authorization: Bearer {token}
Content-Type: application/json

{
    "user_id": 2
}
```

#### Update Lead Status
```http
POST /api/leads/{id}/status
Authorization: Bearer {token}
Content-Type: application/json

{
    "status": "proposal"
}
```

#### Delete Lead
```http
DELETE /api/leads/{id}
Authorization: Bearer {token}
```

#### Get Lead Stats
```http
GET /api/leads/stats
Authorization: Bearer {token}
```

### Contact Messages (Admin)

#### List Messages
```http
GET /api/contact/messages
Authorization: Bearer {token}
```

**Query Parameters:**
- `page` - Page number
- `limit` - Items per page
- `status` - Filter by status (new, read, replied, archived)

#### Get Single Message
```http
GET /api/contact/messages/{id}
Authorization: Bearer {token}
```

#### Update Message Status
```http
POST /api/contact/messages/{id}/status
Authorization: Bearer {token}
Content-Type: application/json

{
    "status": "replied"
}
```

#### Delete Message
```http
DELETE /api/contact/messages/{id}
Authorization: Bearer {token}
```

#### Get Contact Stats
```http
GET /api/contact/stats
Authorization: Bearer {token}
```

### Pages (Admin)

#### List All Pages
```http
GET /api/pages/all
Authorization: Bearer {token}
```

#### Get Single Page
```http
GET /api/pages/{id}
Authorization: Bearer {token}
```

#### Create Page
```http
POST /api/pages
Authorization: Bearer {token}
Content-Type: application/json

{
    "title": "New Page",
    "content": "Page content...",
    "template": "default",
    "status": "active",
    "show_in_menu": true,
    "menu_order": 1
}
```

#### Update Page
```http
PUT /api/pages/{id}
Authorization: Bearer {token}
Content-Type: application/json
```

#### Delete Page
```http
DELETE /api/pages/{id}
Authorization: Bearer {token}
```

#### Get Page Templates
```http
GET /api/pages/templates/list
Authorization: Bearer {token}
```

### Settings (Admin)

#### Get All Settings
```http
GET /api/settings
Authorization: Bearer {token}
```

#### Update Settings
```http
PUT /api/settings
Authorization: Bearer {token}
Content-Type: application/json

{
    "site_name": "ZLO Technologies",
    "site_tagline": "Digital Innovation for Africa",
    "contact_email": "contact@zlotech.net",
    "contact_phone": "+228 92 60 59 49",
    "social_facebook": "https://facebook.com/zlotech",
    "social_twitter": "https://twitter.com/zlotech",
    "social_linkedin": "https://linkedin.com/company/zlotech"
}
```

#### Get Tracking Codes
```http
GET /api/settings/tracking
Authorization: Bearer {token}
```

#### Toggle Maintenance Mode
```http
POST /api/settings/maintenance
Authorization: Bearer {token}
Content-Type: application/json

{
    "enabled": true
}
```

### Uploads (Admin)

#### List Uploads
```http
GET /api/uploads
Authorization: Bearer {token}
```

#### Upload File
```http
POST /api/uploads
Authorization: Bearer {token}
Content-Type: multipart/form-data

file: [binary data]
alt_text: "Image description"
```

#### Delete Upload
```http
DELETE /api/uploads/{id}
Authorization: Bearer {token}
```

### Newsletter (Admin)

#### List Subscribers
```http
GET /api/newsletter/subscribers
Authorization: Bearer {token}
```

**Query Parameters:**
- `page` - Page number
- `limit` - Items per page
- `status` - Filter by status

#### Get Subscriber Stats
```http
GET /api/newsletter/stats
Authorization: Bearer {token}
```

#### Get Growth Stats
```http
GET /api/newsletter/growth?days=30
Authorization: Bearer {token}
```

#### Delete Subscriber
```http
DELETE /api/newsletter/subscribers/{id}
Authorization: Bearer {token}
```

#### Import Subscribers
```http
POST /api/newsletter/import
Authorization: Bearer {token}
Content-Type: application/json

{
    "emails": ["user1@example.com", "user2@example.com"]
}
```

#### Export Subscribers
```http
GET /api/newsletter/export?status=subscribed
Authorization: Bearer {token}
```

### Case Studies (Admin)

#### List All Case Studies
```http
GET /api/case-studies/all
Authorization: Bearer {token}
```

#### Create Case Study
```http
POST /api/case-studies
Authorization: Bearer {token}
Content-Type: application/json

{
    "title": "Client Success Story",
    "client_name": "Acme Inc",
    "problem": "The problem...",
    "solution": "Our solution...",
    "results": ["Result 1", "Result 2"],
    "metrics": [{"label": "ROI", "value": "150%"}],
    "published": true
}
```

#### Update Case Study
```http
PUT /api/case-studies/{id}
Authorization: Bearer {token}
Content-Type: application/json
```

#### Delete Case Study
```http
DELETE /api/case-studies/{id}
Authorization: Bearer {token}
```

### Analytics (Admin)

#### Get Dashboard Stats
```http
GET /api/analytics/dashboard?days=30
Authorization: Bearer {token}
```

#### Get Traffic Data
```http
GET /api/analytics/traffic?days=30
Authorization: Bearer {token}
```

#### Get Real-time Stats
```http
GET /api/analytics/realtime
Authorization: Bearer {token}
```

### Dashboard

#### Get Dashboard Stats
```http
GET /api/dashboard/stats
Authorization: Bearer {token}
```

**Response:**
```json
{
    "leads": {
        "total": 150,
        "new": 25
    },
    "blog_posts": 45,
    "contact_messages": 12,
    "pipeline_value": 1250000
}
```

---

## Response Format

### Success Response
```json
{
    "data": { ... },
    "pagination": {
        "current_page": 1,
        "per_page": 10,
        "total": 100,
        "last_page": 10,
        "from": 1,
        "to": 10
    }
}
```

### Error Response
```json
{
    "error": "Error message",
    "code": 400
}
```

---

## HTTP Status Codes

| Code | Meaning |
|------|---------|
| 200 | OK - Request successful |
| 201 | Created - Resource created successfully |
| 400 | Bad Request - Invalid input |
| 401 | Unauthorized - Authentication required |
| 403 | Forbidden - Insufficient permissions |
| 404 | Not Found - Resource not found |
| 429 | Too Many Requests - Rate limit exceeded |
| 500 | Internal Server Error |

---

## Rate Limiting

API requests are rate-limited to prevent abuse:
- Public endpoints: 100 requests per minute per IP
- Authenticated endpoints: 1000 requests per minute per user

---

## CORS

The API supports Cross-Origin Resource Sharing (CORS) for all origins.

---

## Permissions

Available permissions for role-based access control:

| Permission | Description |
|------------|-------------|
| users.view | View users |
| users.create | Create users |
| users.edit | Edit users |
| users.delete | Delete users |
| solutions.view | View solutions |
| solutions.create | Create solutions |
| solutions.edit | Edit solutions |
| solutions.delete | Delete solutions |
| leads.view | View leads |
| leads.create | Create leads |
| leads.edit | Edit leads |
| leads.delete | Delete leads |
| blog.view | View blog posts |
| blog.create | Create blog posts |
| blog.edit | Edit blog posts |
| blog.delete | Delete blog posts |
| pages.view | View pages |
| pages.create | Create pages |
| pages.edit | Edit pages |
| pages.delete | Delete pages |
| settings.view | View settings |
| settings.edit | Edit settings |
| analytics.view | View analytics |
