import i18n from 'i18next';
import { initReactI18next } from 'react-i18next';
import LanguageDetector from 'i18next-browser-languagedetector';

const resources = {
  fr: {
    translation: {
      // Navigation
      nav: {
        home: 'Accueil',
        about: 'À propos',
        services: 'Services',
        projects: 'Projets',
        contact: 'Contact',
        fbo: 'FBO',
        admin: 'Admin'
      },
      
      // Hero
      hero: {
        ctaPrimary: 'Nos Services',
        ctaSecondary: 'Nous Contacter',
        scrollDown: 'Défiler'
      },
      
      // About
      about: {
        title: 'À Propos',
        mission: 'Notre Mission',
        vision: 'Notre Vision',
        values: 'Nos Valeurs'
      },
      
      // Services
      services: {
        title: 'Nos Services',
        subtitle: 'Des solutions adaptées à vos besoins',
        learnMore: 'En savoir plus',
        features: 'Caractéristiques'
      },
      
      // Projects
      projects: {
        title: 'Nos Projets',
        subtitle: 'Découvrez nos réalisations',
        viewProject: 'Voir le projet',
        technologies: 'Technologies'
      },
      
      // Testimonials
      testimonials: {
        title: 'Témoignages',
        subtitle: 'Ce que nos clients disent de nous'
      },
      
      // Team
      team: {
        title: 'Notre Équipe',
        subtitle: 'Les experts derrière ZLO Technologies'
      },
      
      // Contact
      contact: {
        title: 'Contactez-nous',
        subtitle: 'Parlons de votre projet',
        name: 'Nom',
        email: 'Email',
        phone: 'Téléphone',
        subject: 'Sujet',
        message: 'Message',
        send: 'Envoyer',
        sending: 'Envoi...',
        success: 'Message envoyé avec succès !',
        error: 'Une erreur est survenue. Veuillez réessayer.',
        address: 'Adresse',
        hours: 'Horaires',
        followUs: 'Suivez-nous'
      },
      
      // Footer
      footer: {
        newsletter: 'Newsletter',
        subscribe: 'S\'abonner',
        quickLinks: 'Liens rapides',
        services: 'Services',
        legal: 'Mentions légales'
      },
      
      // FBO
      fbo: {
        title: 'Forever Living Products',
        subtitle: 'Votre distributeur officiel',
        discover: 'Découvrir nos produits',
        becomeFBO: 'Devenir FBO',
        categories: {
          all: 'Tous les produits',
          'aloe-vera': 'Aloe Vera',
          nutrition: 'Nutrition',
          beauty: 'Beauté',
          'personal-care': 'Soins personnels',
          'weight-management': 'Contrôle du poids',
          packs: 'Packs'
        },
        addToCart: 'Ajouter au panier',
        inStock: 'En stock',
        outOfStock: 'Rupture de stock',
        composition: 'Composition',
        dosage: 'Mode d\'emploi',
        benefits: 'Bienfaits',
        cart: 'Panier',
        emptyCart: 'Votre panier est vide',
        total: 'Total',
        checkout: 'Commander',
        continueShopping: 'Continuer les achats',
        contactFBO: 'Contact FBO',
        orderByPhone: 'Commander par téléphone',
        orderByWhatsApp: 'Commander par WhatsApp'
      },
      
      // Admin
      admin: {
        login: 'Connexion Admin',
        username: 'Nom d\'utilisateur',
        password: 'Mot de passe',
        connect: 'Se connecter',
        dashboard: 'Tableau de bord',
        content: 'Contenu',
        sections: 'Sections',
        fbo: 'FBO',
        settings: 'Paramètres',
        logout: 'Déconnexion',
        save: 'Enregistrer',
        cancel: 'Annuler',
        edit: 'Modifier',
        delete: 'Supprimer',
        add: 'Ajouter',
        preview: 'Aperçu',
        export: 'Exporter',
        import: 'Importer',
        reset: 'Réinitialiser'
      },
      
      // Common
      common: {
        loading: 'Chargement...',
        error: 'Erreur',
        success: 'Succès',
        close: 'Fermer',
        open: 'Ouvrir',
        yes: 'Oui',
        no: 'Non',
        back: 'Retour',
        next: 'Suivant',
        search: 'Rechercher',
        filter: 'Filtrer',
        sort: 'Trier',
        all: 'Tous',
        none: 'Aucun',
        more: 'Voir plus',
        less: 'Voir moins'
      }
    }
  },
  en: {
    translation: {
      // Navigation
      nav: {
        home: 'Home',
        about: 'About',
        services: 'Services',
        projects: 'Projects',
        contact: 'Contact',
        fbo: 'FBO',
        admin: 'Admin'
      },
      
      // Hero
      hero: {
        ctaPrimary: 'Our Services',
        ctaSecondary: 'Contact Us',
        scrollDown: 'Scroll'
      },
      
      // About
      about: {
        title: 'About Us',
        mission: 'Our Mission',
        vision: 'Our Vision',
        values: 'Our Values'
      },
      
      // Services
      services: {
        title: 'Our Services',
        subtitle: 'Solutions tailored to your needs',
        learnMore: 'Learn more',
        features: 'Features'
      },
      
      // Projects
      projects: {
        title: 'Our Projects',
        subtitle: 'Discover our work',
        viewProject: 'View project',
        technologies: 'Technologies'
      },
      
      // Testimonials
      testimonials: {
        title: 'Testimonials',
        subtitle: 'What our clients say about us'
      },
      
      // Team
      team: {
        title: 'Our Team',
        subtitle: 'The experts behind ZLO Technologies'
      },
      
      // Contact
      contact: {
        title: 'Contact Us',
        subtitle: 'Let\'s talk about your project',
        name: 'Name',
        email: 'Email',
        phone: 'Phone',
        subject: 'Subject',
        message: 'Message',
        send: 'Send',
        sending: 'Sending...',
        success: 'Message sent successfully!',
        error: 'An error occurred. Please try again.',
        address: 'Address',
        hours: 'Hours',
        followUs: 'Follow us'
      },
      
      // Footer
      footer: {
        newsletter: 'Newsletter',
        subscribe: 'Subscribe',
        quickLinks: 'Quick links',
        services: 'Services',
        legal: 'Legal'
      },
      
      // FBO
      fbo: {
        title: 'Forever Living Products',
        subtitle: 'Your official distributor',
        discover: 'Discover our products',
        becomeFBO: 'Become FBO',
        categories: {
          all: 'All products',
          'aloe-vera': 'Aloe Vera',
          nutrition: 'Nutrition',
          beauty: 'Beauty',
          'personal-care': 'Personal Care',
          'weight-management': 'Weight Management',
          packs: 'Packs'
        },
        addToCart: 'Add to cart',
        inStock: 'In stock',
        outOfStock: 'Out of stock',
        composition: 'Composition',
        dosage: 'Directions',
        benefits: 'Benefits',
        cart: 'Cart',
        emptyCart: 'Your cart is empty',
        total: 'Total',
        checkout: 'Order',
        continueShopping: 'Continue shopping',
        contactFBO: 'Contact FBO',
        orderByPhone: 'Order by phone',
        orderByWhatsApp: 'Order by WhatsApp'
      },
      
      // Admin
      admin: {
        login: 'Admin Login',
        username: 'Username',
        password: 'Password',
        connect: 'Connect',
        dashboard: 'Dashboard',
        content: 'Content',
        sections: 'Sections',
        fbo: 'FBO',
        settings: 'Settings',
        logout: 'Logout',
        save: 'Save',
        cancel: 'Cancel',
        edit: 'Edit',
        delete: 'Delete',
        add: 'Add',
        preview: 'Preview',
        export: 'Export',
        import: 'Import',
        reset: 'Reset'
      },
      
      // Common
      common: {
        loading: 'Loading...',
        error: 'Error',
        success: 'Success',
        close: 'Close',
        open: 'Open',
        yes: 'Yes',
        no: 'No',
        back: 'Back',
        next: 'Next',
        search: 'Search',
        filter: 'Filter',
        sort: 'Sort',
        all: 'All',
        none: 'None',
        more: 'See more',
        less: 'See less'
      }
    }
  }
};

i18n
  .use(LanguageDetector)
  .use(initReactI18next)
  .init({
    resources,
    fallbackLng: 'fr',
    interpolation: {
      escapeValue: false
    },
    detection: {
      order: ['localStorage', 'navigator'],
      caches: ['localStorage']
    }
  });

export default i18n;
