import { useEffect, useRef } from 'react';
import gsap from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';

gsap.registerPlugin(ScrollTrigger);

const stats = [
  { value: '10+', label: 'Années d\'expérience' },
  { value: '50+', label: 'Projets réalisés' },
  { value: '30+', label: 'Clients satisfaits' },
  { value: '15+', label: 'Experts' },
];

export default function About() {
  const sectionRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    const ctx = gsap.context(() => {
      gsap.fromTo(
        '.about-content',
        { y: 50, opacity: 0 },
        {
          y: 0,
          opacity: 1,
          duration: 0.8,
          scrollTrigger: {
            trigger: sectionRef.current,
            start: 'top 80%',
            toggleActions: 'play none none reverse',
          },
        }
      );

      gsap.fromTo(
        '.stat-item',
        { y: 30, opacity: 0 },
        {
          y: 0,
          opacity: 1,
          duration: 0.6,
          stagger: 0.1,
          scrollTrigger: {
            trigger: '.stats-grid',
            start: 'top 85%',
            toggleActions: 'play none none reverse',
          },
        }
      );
    }, sectionRef);

    return () => ctx.revert();
  }, []);

  return (
    <section ref={sectionRef} id="about" className="section-padding bg-[#0a0a0a] relative">
      <div className="container-custom">
        <div className="about-content">
          {/* Section Label */}
          <span className="text-sm text-white/40 uppercase tracking-widest mb-4 block">
            À propos
          </span>

          {/* Main Title */}
          <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold text-white mb-8 max-w-3xl">
            NOUS VOUS AIDONS À CONSTRUIRE VOTRE <span className="gradient-text">VISION.</span>
          </h2>

          {/* Description */}
          <div className="grid lg:grid-cols-2 gap-12 mb-16">
            <p className="text-white/60 text-lg leading-relaxed">
              ZLO Technologies est une société de services en ingénierie informatique (SSII) qui se spécialise dans le développement et la fourniture de solutions technologiques innovantes et personnalisées dans un large éventail de domaines informatiques.
            </p>
            <p className="text-white/60 text-lg leading-relaxed">
              Nous proposons des services dans des secteurs variés tels que le développement de logiciels, incluant les systèmes ERP, CRM, e-Procurement, cloud computing, ainsi que les solutions de gestion de documents GED/ECM.
            </p>
          </div>

          {/* Extended Description */}
          <p className="text-white/60 text-lg leading-relaxed mb-16 max-w-4xl">
            De plus, nous intervenons dans l'optimisation des infrastructures IT et de la sécurité des données, la géolocalisation, l'Internet des objets (IoT) et l'Industrie 4.0. Notre société se distingue par son engagement ferme envers l'excellence technologique et sa capacité à s'adapter aux besoins changeants du monde numérique d'aujourd'hui.
          </p>

          {/* Stats */}
          <div className="stats-grid grid grid-cols-2 lg:grid-cols-4 gap-8">
            {stats.map((stat, index) => (
              <div key={index} className="stat-item text-center lg:text-left">
                <div className="text-4xl md:text-5xl font-bold gradient-text mb-2">
                  {stat.value}
                </div>
                <div className="text-white/50 text-sm">
                  {stat.label}
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
}
