import { useCallback } from 'react';
import { Toaster } from 'sonner';
import Header from '@/components/Header';
import Footer from '@/components/Footer';
import Hero from '@/sections/Hero';
import Approach from '@/sections/Approach';
import About from '@/sections/About';
import Services from '@/sections/Services';
import Projects from '@/sections/Projects';
import Team from '@/sections/Team';
import Contact from '@/sections/Contact';

export default function MainWebsite() {
  const handleNavigate = useCallback((section: string) => {
    const element = document.getElementById(section);
    if (element) {
      element.scrollIntoView({ behavior: 'smooth' });
    }
  }, []);

  return (
    <div className="min-h-screen bg-[#0a0a0a]">
      <Header onNavigate={handleNavigate} />
      
      <main>
        <Hero onNavigate={handleNavigate} />
        <Approach onNavigate={handleNavigate} />
        <About />
        <Services />
        <Projects />
        <Team />
        <Contact />
      </main>
      
      <Footer />
      
      <Toaster 
        position="top-right" 
        toastOptions={{
          style: {
            background: '#141414',
            color: '#fff',
            border: '1px solid rgba(255,255,255,0.1)',
          },
        }}
      />
    </div>
  );
}
