// Section Types
export interface Section {
  id: string;
  name: string;
  label: string;
  labelEn: string;
  description: string;
  isVisible: boolean;
  showInMenu: boolean;
  order: number;
  icon: string;
}

export interface MenuItem {
  id: string;
  label: string;
  labelEn: string;
  href: string;
  isVisible: boolean;
  order: number;
  icon: string;
}

// Content Types
export interface HeroContent {
  title: string;
  subtitle: string;
  description: string;
  ctaPrimary: string;
  ctaSecondary: string;
  backgroundImage: string;
}

export interface AboutValue {
  title: string;
  description: string;
  icon: string;
}

export interface AboutStat {
  value: string;
  label: string;
}

export interface AboutContent {
  title: string;
  description: string;
  mission: string;
  vision: string;
  values: AboutValue[];
  stats: AboutStat[];
  image: string;
}

export interface ServiceContent {
  id: string;
  title: string;
  shortDescription: string;
  fullDescription: string;
  icon: string;
  features: string[];
  image: string;
}

export interface ProjectContent {
  id: string;
  title: string;
  category: string;
  description: string;
  image: string;
  technologies: string[];
}

export interface TestimonialContent {
  id: string;
  name: string;
  role: string;
  company: string;
  content: string;
  avatar: string;
  rating: number;
}

export interface TeamMemberSocial {
  linkedin?: string;
  twitter?: string;
  github?: string;
  email?: string;
  dribbble?: string;
}

export interface TeamMember {
  id: string;
  name: string;
  role: string;
  bio: string;
  image: string;
  social: TeamMemberSocial;
}

export interface ContactContent {
  title: string;
  subtitle: string;
  description: string;
  address: string;
  phone: string;
  email: string;
  hours: string;
  mapEmbedUrl: string;
  socialLinks: {
    facebook: string;
    twitter: string;
    linkedin: string;
    instagram: string;
    youtube: string;
  };
}

export interface FooterLink {
  label: string;
  href: string;
}

export interface FooterContent {
  companyDescription: string;
  quickLinks: FooterLink[];
  services: FooterLink[];
  newsletterTitle: string;
  newsletterDescription: string;
  copyright: string;
  legalLinks: FooterLink[];
}

export interface SiteContent {
  hero: HeroContent;
  about: AboutContent;
  services: ServiceContent[];
  projects: ProjectContent[];
  testimonials: TestimonialContent[];
  team: TeamMember[];
  contact: ContactContent;
  footer: FooterContent;
}

// FBO Types
export type ProductCategory = 
  | 'aloe-vera' 
  | 'nutrition' 
  | 'beauty' 
  | 'personal-care' 
  | 'weight-management' 
  | 'packs';

export interface Product {
  id: string;
  reference: string;
  name: string;
  nameEn: string;
  category: ProductCategory;
  price: number;
  priceEUR: number;
  priceUSD: number;
  priceGBP: number;
  image: string;
  images: string[];
  description: string;
  descriptionEn: string;
  composition: string;
  compositionEn: string;
  dosage: string;
  dosageEn: string;
  benefits: string[];
  benefitsEn: string[];
  inStock: boolean;
  featured: boolean;
  isPack?: boolean;
}

export interface FBOHeroContent {
  title: string;
  titleEn: string;
  subtitle: string;
  subtitleEn: string;
  description: string;
  descriptionEn: string;
  ctaPrimary: string;
  ctaPrimaryEn: string;
  ctaSecondary: string;
  ctaSecondaryEn: string;
  backgroundImage: string;
}

export interface FBOContactContent {
  title: string;
  titleEn: string;
  subtitle: string;
  subtitleEn: string;
  description: string;
  descriptionEn: string;
  phone: string;
  email: string;
  whatsapp: string;
  address: string;
  hours: string;
  hoursEn: string;
}

export interface FBOTheme {
  primaryColor: string;
  secondaryColor: string;
  accentColor: string;
  backgroundColor: string;
  textColor: string;
  cardBackground: string;
}

export interface CartItem {
  product: Product;
  quantity: number;
}

// Currency Types
export type CurrencyCode = 'XOF' | 'EUR' | 'USD' | 'GBP';

export interface Currency {
  code: CurrencyCode;
  name: string;
  symbol: string;
  flag: string;
}

export interface CurrencyRates {
  XOF: number;
  EUR: number;
  USD: number;
  GBP: number;
}

// Auth Types
export interface AdminUser {
  username: string;
  password: string;
  role: 'admin' | 'editor';
}

export interface User {
  id: string;
  username: string;
  role: 'admin' | 'editor';
}
