# ZLO Platform - Guide de Déploiement Complet

## 📋 Table des matières
1. [Prérequis](#prérequis)
2. [Choix de l'hébergement](#choix-de-lhébergement)
3. [Configuration du serveur](#configuration-du-serveur)
4. [Déploiement](#déploiement)
5. [Configuration base de données](#configuration-base-de-données)
6. [SSL/HTTPS](#sslhttps)
7. [Vérification](#vérification)
8. [Maintenance](#maintenance)

---

## Prérequis

### Configuration minimale requise

```
✓ PHP >= 8.0
✓ MySQL >= 8.0 ou MariaDB >= 10.5
✓ Apache >= 2.4 avec mod_rewrite
✓ Extensions PHP : PDO, PDO_MySQL, JSON, MBString, GD, OpenSSL
✓ Espace disque : 500 Mo minimum
✓ RAM : 512 Mo minimum
✓ Bande passante : Selon votre trafic
```

### Extensions PHP requises

```bash
# Vérifier les extensions installées
php -m | grep -E "pdo|json|mbstring|gd|openssl"
```

---

## Choix de l'hébergement

### Option 1 : Hébergement mutualisé (Budget limité)

**Recommandé pour :** Démarrage, petit trafic (< 1000 visiteurs/jour)

**Hébergeurs compatibles :**
- **Hostinger** (Business plan ~3€/mois)
- **OVH** (Pro plan ~8€/mois)
- **Infomaniak** (Cloud Start ~10€/mois)
- **Bluehost** (Choice Plus ~8€/mois)

**Caractéristiques requises :**
- PHP 8.0+ sélectionnable
- MySQL 8.0+
- Accès SSH (optionnel mais recommandé)
- Certificat SSL gratuit (Let's Encrypt)
- Espace disque : 10 Go+

### Option 2 : VPS (Recommandé)

**Recommandé pour :** Trafic moyen, contrôle total, croissance

**Fournisseurs :**
- **DigitalOcean** (Droplet 2GB RAM ~$12/mois)
- **Vultr** (2GB RAM ~$10/mois)
- **Linode** (2GB RAM ~$12/mois)
- **AWS Lightsail** (2GB RAM ~$10/mois)

**Avantages :**
- Contrôle total du serveur
- Meilleures performances
- Scalable selon besoins
- Coût prévisible

### Option 3 : Serveur dédié (Enterprise)

**Recommandé pour :** Grand trafic (> 10000 visiteurs/jour), entreprises

**Fournisseurs :**
- **OVH** (Serveurs dédiés ~50€/mois)
- **Hetzner** (Serveurs dédiés ~40€/mois)

---

## Configuration du serveur

### Étape 1 : Créer un VPS (DigitalOcean exemple)

```bash
# 1. Créer un compte DigitalOcean
# 2. Créer un nouveau Droplet
#    - Image : Ubuntu 22.04 (LTS)
#    - Plan : Basic
#    - CPU : Regular Intel with SSD
#    - RAM : 2 GB / 1 CPU / 50 GB SSD
#    - Datacenter : Frankfurt (ou le plus proche)
#    - Authentification : Clé SSH (recommandé)
#    - Hostname : zlo-platform

# 3. Noter l'adresse IP attribuée (ex: 123.456.789.012)
```

### Étape 2 : Connexion au serveur

```bash
# Connexion SSH
ssh root@123.456.789.012

# Mettre à jour le système
apt update && apt upgrade -y

# Définir le fuseau horaire
timedatectl set-timezone Africa/Lome
```

### Étape 3 : Installer les dépendances

```bash
# Installer Apache
apt install -y apache2

# Installer MySQL
apt install -y mysql-server

# Sécuriser MySQL
mysql_secure_installation

# Répondre aux questions :
# - Validate Password Component : Y (MEDIUM)
# - Remove anonymous users : Y
# - Disallow root login remotely : Y
# - Remove test database : Y
# - Reload privilege tables : Y
```

### Étape 4 : Installer PHP 8.1

```bash
# Ajouter le repository PHP
apt install -y software-properties-common
add-apt-repository ppa:ondrej/php -y
apt update

# Installer PHP et extensions
apt install -y php8.1 php8.1-fpm php8.1-mysql php8.1-json \
    php8.1-mbstring php8.1-gd php8.1-curl php8.1-xml \
    php8.1-zip php8.1-intl php8.1-opcache

# Vérifier l'installation
php -v
```

### Étape 5 : Configurer Apache

```bash
# Activer les modules nécessaires
a2enmod rewrite
a2enmod headers
a2enmod ssl
a2enmod expires
a2enmod deflate
a2enmod env

# Redémarrer Apache
systemctl restart apache2

# Vérifier le statut
systemctl status apache2
```

### Étape 6 : Configurer PHP

```bash
# Éditer php.ini
nano /etc/php/8.1/fpm/php.ini

# Modifier ces lignes :
upload_max_filesize = 10M
post_max_size = 10M
memory_limit = 256M
max_execution_time = 300
max_input_vars = 3000

# Redémarrer PHP-FPM
systemctl restart php8.1-fpm
```

---

## Déploiement

### Étape 1 : Créer la structure des dossiers

```bash
# Créer le répertoire du site
mkdir -p /var/www/zlotech.net
mkdir -p /var/www/zlotech.net/logs
mkdir -p /var/www/zlotech.net/uploads

# Définir les permissions
chown -R www-data:www-data /var/www/zlotech.net
chmod -R 755 /var/www/zlotech.net
```

### Étape 2 : Transférer les fichiers

#### Méthode A : Via SCP (depuis votre machine locale)

```bash
# Sur votre machine locale, compresser le projet
cd /mnt/okcomputer/output
tar -czvf zlo-platform.tar.gz zlo-platform

# Transférer vers le serveur
scp zlo-platform.tar.gz root@123.456.789.012:/var/www/

# Sur le serveur, extraire
cd /var/www
tar -xzvf zlo-platform.tar.gz
mv zlo-platform/* zlotech.net/
mv zlo-platform/.[^.]* zlotech.net/ 2>/dev/null || true
rmdir zlo-platform
rm zlo-platform.tar.gz
```

#### Méthode B : Via Git (si vous utilisez Git)

```bash
# Sur le serveur
cd /var/www/zlotech.net
git clone https://github.com/votre-compte/zlo-platform.git .
```

#### Méthode C : Via FTP/SFTP

```bash
# Utiliser FileZilla ou un client FTP
# Hôte : sftp://123.456.789.012
# Utilisateur : root (ou votre utilisateur)
# Port : 22
# Transférer tous les fichiers dans /var/www/zlotech.net
```

### Étape 3 : Configurer les permissions

```bash
cd /var/www/zlotech.net

# Permissions des dossiers
chmod -R 755 .
chmod -R 775 uploads/
chmod -R 775 logs/

# Propriétaire
chown -R www-data:www-data .

# Fichiers spéciaux
chmod 644 .htaccess
chmod 644 api/config/config.php
```

### Étape 4 : Créer le VirtualHost Apache

```bash
# Créer le fichier de configuration
nano /etc/apache2/sites-available/zlotech.net.conf
```

Coller cette configuration :

```apache
<VirtualHost *:80>
    ServerName zlotech.net
    ServerAlias www.zlotech.net
    DocumentRoot /var/www/zlotech.net/public
    
    # Logs
    ErrorLog /var/www/zlotech.net/logs/error.log
    CustomLog /var/www/zlotech.net/logs/access.log combined
    
    # Directory settings
    <Directory /var/www/zlotech.net/public>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
    
    # API directory
    <Directory /var/www/zlotech.net/api>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
    
    # Protect sensitive directories
    <Directory /var/www/zlotech.net/api/config>
        Require all denied
    </Directory>
    
    <Directory /var/www/zlotech.net/logs>
        Require all denied
    </Directory>
    
    # Enable compression
    <IfModule mod_deflate.c>
        AddOutputFilterByType DEFLATE text/html text/plain text/xml text/css
        AddOutputFilterByType DEFLATE application/javascript application/json
        AddOutputFilterByType DEFLATE image/svg+xml
    </IfModule>
    
    # Browser caching
    <IfModule mod_expires.c>
        ExpiresActive On
        ExpiresByType image/jpg "access plus 1 month"
        ExpiresByType image/jpeg "access plus 1 month"
        ExpiresByType image/png "access plus 1 month"
        ExpiresByType text/css "access plus 1 week"
        ExpiresByType application/javascript "access plus 1 week"
    </IfModule>
</VirtualHost>
```

Activer le site :

```bash
# Activer le site
a2ensite zlotech.net.conf

# Désactiver le site par défaut
a2dissite 000-default.conf

# Tester la configuration
apache2ctl configtest

# Redémarrer Apache
systemctl restart apache2
```

---

## Configuration base de données

### Étape 1 : Créer la base de données

```bash
# Se connecter à MySQL
mysql -u root -p

# Créer la base de données
CREATE DATABASE zlo_platform CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

# Créer un utilisateur dédié
CREATE USER 'zlo_user'@'localhost' IDENTIFIED BY 'VotreMotDePasseFort123!';

# Accorder les privilèges
GRANT ALL PRIVILEGES ON zlo_platform.* TO 'zlo_user'@'localhost';

# Appliquer les changements
FLUSH PRIVILEGES;

# Quitter
EXIT;
```

### Étape 2 : Importer le schéma

```bash
# Importer le schéma de la base de données
cd /var/www/zlotech.net
mysql -u zlo_user -p zlo_platform < database/schema.sql

# Vérifier les tables
mysql -u zlo_user -p -e "USE zlo_platform; SHOW TABLES;"
```

### Étape 3 : Créer le fichier .env

```bash
# Copier le fichier exemple
cd /var/www/zlotech.net
cp .env.example .env

# Éditer le fichier
nano .env
```

Configuration complète du fichier .env :

```env
# ============================================
# ZLO Platform - Configuration Environment
# ============================================

# Application
APP_ENV=production
APP_DEBUG=false
APP_URL=https://zlotech.net
APP_NAME="ZLO Technologies"
APP_VERSION=1.0.0

# ============================================
# Database Configuration
# ============================================
DB_HOST=localhost
DB_PORT=3306
DB_NAME=zlo_platform
DB_USER=zlo_user
DB_PASSWORD=VotreMotDePasseFort123!

# ============================================
# JWT Configuration
# ============================================
# Générer une clé secrète forte :
# openssl rand -base64 32
JWT_SECRET=votre_cle_secrete_tres_longue_et_aleatoire_ici
JWT_EXPIRATION=7200
JWT_REFRESH_EXPIRATION=604800

# ============================================
# Email Configuration (SMTP)
# ============================================
# Option 1 : Gmail SMTP
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=votre-email@gmail.com
MAIL_PASSWORD=votre-mot-de-passe-app
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@zlotech.net
MAIL_FROM_NAME="ZLO Technologies"

# Option 2 : SendGrid
# MAIL_HOST=smtp.sendgrid.net
# MAIL_PORT=587
# MAIL_USERNAME=apikey
# MAIL_PASSWORD=votre-cle-sendgrid
# MAIL_ENCRYPTION=tls

# Option 3 : Mailgun
# MAIL_HOST=smtp.mailgun.org
# MAIL_PORT=587
# MAIL_USERNAME=postmaster@votre-domaine.com
# MAIL_PASSWORD=votre-cle-mailgun
# MAIL_ENCRYPTION=tls

# ============================================
# Upload Configuration
# ============================================
UPLOAD_MAX_SIZE=10485760
UPLOAD_ALLOWED_TYPES=jpg,jpeg,png,gif,webp,svg,pdf,doc,docx
UPLOAD_PATH=/var/www/zlotech.net/uploads

# ============================================
# Security Configuration
# ============================================
CSRF_TOKEN_NAME=csrf_token
SESSION_LIFETIME=7200
SESSION_SECURE=true
SESSION_HTTP_ONLY=true
SESSION_SAME_SITE=Strict

# Rate Limiting
RATE_LIMIT_LOGIN=5
RATE_LIMIT_WINDOW=900

# ============================================
# reCAPTCHA (Optionnel)
# ============================================
RECAPTCHA_SITE_KEY=
RECAPTCHA_SECRET_KEY=

# ============================================
# Analytics (Optionnel)
# ============================================
GOOGLE_ANALYTICS_ID=
FACEBOOK_PIXEL_ID=

# ============================================
# Maintenance Mode
# ============================================
MAINTENANCE_MODE=false
MAINTENANCE_MESSAGE="Site en maintenance. Nous revenons bientôt."
```

### Étape 4 : Générer la clé JWT

```bash
# Générer une clé secrète JWT
cd /var/www/zlotech.net
JWT_SECRET=$(openssl rand -base64 32)
echo "Votre JWT_SECRET : $JWT_SECRET"

# Copier cette valeur dans le fichier .env
nano .env
# Remplacer JWT_SECRET=... par la valeur générée
```

---

## SSL/HTTPS

### Étape 1 : Installer Certbot (Let's Encrypt)

```bash
# Installer Certbot
apt install -y certbot python3-certbot-apache

# Vérifier l'installation
certbot --version
```

### Étape 2 : Obtenir le certificat SSL

```bash
# Générer le certificat
certbot --apache -d zlotech.net -d www.zlotech.net

# Suivre les instructions :
# - Entrer votre email
# - Accepter les termes
# - Choisir : Redirect (option 2) pour forcer HTTPS

# Vérifier le renouvellement automatique
certbot renew --dry-run
```

### Étape 3 : Vérifier la configuration SSL

```bash
# Vérifier le VirtualHost HTTPS
nano /etc/apache2/sites-available/zlotech.net-le-ssl.conf

# Redémarrer Apache
systemctl restart apache2

# Tester SSL
# Visiter : https://www.ssllabs.com/ssltest/analyze.html?d=zlotech.net
```

---

## Vérification

### Étape 1 : Tester l'API

```bash
# Test de santé
curl -X GET https://zlotech.net/api/health

# Test de connexion base de données
curl -X GET https://zlotech.net/api/solutions

# Test d'authentification (doit échouer sans token)
curl -X GET https://zlotech.net/api/dashboard/stats
```

### Étape 2 : Vérifier les logs

```bash
# Logs Apache
tail -f /var/log/apache2/error.log

# Logs de l'application
tail -f /var/www/zlotech.net/logs/error.log
tail -f /var/www/zlotech.net/logs/app.log
```

### Étape 3 : Vérifier les permissions

```bash
# Vérifier les permissions
cd /var/www/zlotech.net
ls -la

# Vérifier les dossiers critiques
ls -la uploads/
ls -la logs/
ls -la api/config/
```

### Étape 4 : Test complet

```bash
# Créer un script de test
cat > /tmp/test_deployment.sh << 'EOF'
#!/bin/bash

echo "=== Test de déploiement ZLO Platform ==="
echo ""

# Test 1 : Site accessible
echo "Test 1 : Vérification du site..."
HTTP_CODE=$(curl -s -o /dev/null -w "%{http_code}" https://zlotech.net)
if [ "$HTTP_CODE" = "200" ]; then
    echo "✓ Site accessible (HTTP 200)"
else
    echo "✗ Site inaccessible (HTTP $HTTP_CODE)"
fi

# Test 2 : API accessible
echo "Test 2 : Vérification de l'API..."
API_RESPONSE=$(curl -s https://zlotech.net/api/health)
if echo "$API_RESPONSE" | grep -q "healthy"; then
    echo "✓ API fonctionnelle"
else
    echo "✗ API non fonctionnelle"
fi

# Test 3 : Base de données
echo "Test 3 : Vérification de la base de données..."
mysql -u zlo_user -p'VotreMotDePasseFort123!' -e "SELECT COUNT(*) FROM zlo_platform.users;" > /dev/null 2>&1
if [ $? -eq 0 ]; then
    echo "✓ Base de données connectée"
else
    echo "✗ Problème de connexion BDD"
fi

# Test 4 : Permissions uploads
echo "Test 4 : Vérification des permissions..."
if [ -w "/var/www/zlotech.net/uploads" ]; then
    echo "✓ Dossier uploads accessible en écriture"
else
    echo "✗ Problème de permissions uploads"
fi

# Test 5 : SSL
echo "Test 5 : Vérification SSL..."
SSL_VALID=$(curl -s -o /dev/null -w "%{http_code}" https://zlotech.net)
if [ "$SSL_VALID" = "200" ]; then
    echo "✓ SSL fonctionnel"
else
    echo "✗ Problème SSL"
fi

echo ""
echo "=== Tests terminés ==="
EOF

chmod +x /tmp/test_deployment.sh
/tmp/test_deployment.sh
```

---

## Configuration DNS

### Étape 1 : Configurer les enregistrements DNS

Chez votre registrar (OVH, GoDaddy, Namecheap, etc.) :

```
Type    Nom              Valeur                      TTL
A       @                123.456.789.012            3600
A       www              123.456.789.012            3600
MX      @                10 mail.zlotech.net        3600
TXT     @                "v=spf1 include:_spf.google.com ~all"  3600
```

### Étape 2 : Attendre la propagation

```bash
# Vérifier la propagation DNS
dig zlotech.net
dig www.zlotech.net

# Ou utiliser un service en ligne
# https://www.whatsmydns.net/
```

---

## Maintenance

### Sauvegardes automatiques

```bash
# Créer un script de backup
mkdir -p /var/backups/zlotech
cat > /usr/local/bin/backup-zlotech.sh << 'EOF'
#!/bin/bash

DATE=$(date +%Y%m%d_%H%M%S)
BACKUP_DIR="/var/backups/zlotech"
DB_NAME="zlo_platform"
DB_USER="zlo_user"
DB_PASS="VotreMotDePasseFort123!"

# Backup base de données
mysqldump -u $DB_USER -p$DB_PASS $DB_NAME | gzip > $BACKUP_DIR/db_$DATE.sql.gz

# Backup fichiers
tar -czf $BACKUP_DIR/files_$DATE.tar.gz -C /var/www zlotech.net

# Garder seulement les 7 derniers jours
find $BACKUP_DIR -name "*.sql.gz" -mtime +7 -delete
find $BACKUP_DIR -name "*.tar.gz" -mtime +7 -delete

echo "Backup terminé : $DATE"
EOF

chmod +x /usr/local/bin/backup-zlotech.sh

# Ajouter au crontab (tous les jours à 2h du matin)
echo "0 2 * * * /usr/local/bin/backup-zlotech.sh >> /var/log/backup-zlotech.log 2>&1" | crontab -
```

### Mises à jour

```bash
# Script de mise à jour
cat > /usr/local/bin/update-zlotech.sh << 'EOF'
#!/bin/bash

echo "Mise à jour ZLO Platform..."

cd /var/www/zlotech.net

# Backup avant mise à jour
/usr/local/bin/backup-zlotech.sh

# Pull les changements (si utilisé avec Git)
# git pull origin main

# Mettre à jour les permissions
chown -R www-data:www-data .
chmod -R 755 .
chmod -R 775 uploads/
chmod -R 775 logs/

# Redémarrer Apache
systemctl restart apache2

echo "Mise à jour terminée"
EOF

chmod +x /usr/local/bin/update-zlotech.sh
```

### Monitoring

```bash
# Installer Netdata (monitoring)
bash <(curl -Ss https://my-netdata.io/kickstart.sh)

# Accéder au dashboard
# http://123.456.789.012:19999
```

---

## Dépannage

### Problème : Erreur 500

```bash
# Vérifier les logs
tail -50 /var/log/apache2/error.log
tail -50 /var/www/zlotech.net/logs/error.log

# Vérifier les permissions
chown -R www-data:www-data /var/www/zlotech.net

# Vérifier la configuration Apache
apache2ctl configtest
```

### Problème : API ne répond pas

```bash
# Vérifier que mod_rewrite est activé
a2enmod rewrite
systemctl restart apache2

# Vérifier le fichier .htaccess
cat /var/www/zlotech.net/.htaccess
```

### Problème : Connexion base de données

```bash
# Tester la connexion
mysql -u zlo_user -p -e "SELECT 1;"

# Vérifier les privilèges
mysql -u root -p -e "SHOW GRANTS FOR 'zlo_user'@'localhost';"
```

### Problème : Uploads ne fonctionnent pas

```bash
# Vérifier les permissions
chmod -R 775 /var/www/zlotech.net/uploads
chown -R www-data:www-data /var/www/zlotech.net/uploads

# Vérifier la configuration PHP
grep -E "upload_max_filesize|post_max_size" /etc/php/8.1/fpm/php.ini
```

---

## Checklist finale

### Avant mise en production

- [ ] Changer le mot de passe admin par défaut
- [ ] Générer une nouvelle clé JWT_SECRET
- [ ] Configurer les emails SMTP
- [ ] Activer SSL/HTTPS
- [ ] Configurer les sauvegardes automatiques
- [ ] Tester toutes les fonctionnalités
- [ ] Vérifier les logs d'erreurs
- [ ] Configurer le monitoring
- [ ] Supprimer install.php
- [ ] Mettre APP_DEBUG à false

### Post-déploiement

- [ ] Vérifier le site sur mobile
- [ ] Tester les formulaires
- [ ] Vérifier les emails
- [ ] Tester l'upload de fichiers
- [ ] Vérifier les statistiques analytics
- [ ] Tester l'API avec des outils (Postman)

---

## Coûts estimés

### VPS DigitalOcean (Recommandé)

| Composant | Coût mensuel |
|-----------|--------------|
| VPS 2GB RAM | $12 (~11€) |
| Backup (20% du VPS) | $2.40 (~2€) |
| Domaine (.net) | $12/an (~1€/mois) |
| **Total** | **~14€/mois** |

### Hébergement mutualisé (Budget)

| Composant | Coût mensuel |
|-----------|--------------|
| Hostinger Business | ~3€ |
| Domaine | ~1€ |
| **Total** | **~4€/mois** |

---

## Support

En cas de problème :

1. Consulter les logs : `/var/log/apache2/error.log`
2. Vérifier la documentation API : `API_DOCUMENTATION.md`
3. Contacter : support@zlotech.net

---

**Dernière mise à jour : 2024**
**Version : 1.0.0**
