import { useEffect } from 'react';
import { useTranslation } from 'react-i18next';
import { ArrowLeft, Shield } from 'lucide-react';

const PrivacyPage = () => {
  const { i18n } = useTranslation();

  useEffect(() => {
    window.scrollTo(0, 0);
  }, []);

  const goBack = () => {
    window.history.back();
  };

  const content = i18n.language === 'fr' ? {
    title: 'Politique de Confidentialité',
    lastUpdate: 'Dernière mise à jour : Février 2026',
    sections: [
      {
        title: '1. Introduction',
        content: `
          <p>ZLO Technologies s'engage à protéger la vie privée des utilisateurs de son site web. Cette politique de confidentialité explique comment nous collectons, utilisons, partageons et protégeons vos informations personnelles lorsque vous utilisez notre site.</p>
          <p class="mt-4">En utilisant notre site, vous acceptez les pratiques décrites dans cette politique de confidentialité.</p>
        `
      },
      {
        title: '2. Données collectées',
        content: `
          <p>Nous collectons les types d'informations suivants :</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li><strong>Informations de contact</strong> : nom, adresse email, numéro de téléphone lorsque vous remplissez notre formulaire de contact</li>
            <li><strong>Informations techniques</strong> : adresse IP, type de navigateur, système d'exploitation, pages visitées</li>
            <li><strong>Préférences</strong> : langue préférée, choix de cookies</li>
            <li><strong>Communications</strong> : contenu des messages que vous nous envoyez</li>
          </ul>
        `
      },
      {
        title: '3. Finalités du traitement',
        content: `
          <p>Nous utilisons vos données personnelles pour :</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li>Répondre à vos demandes et questions</li>
            <li>Vous fournir les services demandés</li>
            <li>Améliorer notre site et nos services</li>
            <li>Vous envoyer des informations sur nos services (avec votre consentement)</li>
            <li>Respecter nos obligations légales</li>
            <li>Assurer la sécurité de notre site</li>
          </ul>
        `
      },
      {
        title: '4. Base légale du traitement',
        content: `
          <p>Nous traitons vos données personnelles sur les bases légales suivantes :</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li><strong>Consentement</strong> : lorsque vous avez explicitement accepté le traitement</li>
            <li><strong>Contrat</strong> : lorsque le traitement est nécessaire à l'exécution d'un contrat</li>
            <li><strong>Obligation légale</strong> : lorsque nous sommes tenus par la loi de traiter vos données</li>
            <li><strong>Intérêt légitime</strong> : pour améliorer nos services et assurer la sécurité</li>
          </ul>
        `
      },
      {
        title: '5. Conservation des données',
        content: `
          <p>Nous conservons vos données personnelles uniquement le temps nécessaire aux finalités pour lesquelles elles ont été collectées :</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li>Données de contact : 3 ans après le dernier contact</li>
            <li>Données de cookies : 13 mois maximum</li>
            <li>Données techniques : 1 an</li>
          </ul>
          <p class="mt-4">Passé ces délais, vos données sont supprimées ou anonymisées.</p>
        `
      },
      {
        title: '6. Partage des données',
        content: `
          <p>Nous ne vendons ni ne louons vos données personnelles à des tiers. Nous pouvons partager vos données avec :</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li><strong>Prestataires de services</strong> : hébergement, maintenance, qui agissent en notre nom</li>
            <li><strong>Autorités légales</strong> : lorsque la loi nous y oblige</li>
          </ul>
          <p class="mt-4">Tous nos prestataires sont soumis à des obligations de confidentialité et de sécurité.</p>
        `
      },
      {
        title: '7. Sécurité des données',
        content: `
          <p>Nous mettons en œuvre des mesures de sécurité techniques et organisationnelles appropriées pour protéger vos données personnelles contre :</p>
          <ul class="list-disc ml-6 mt-2 space-y-1">
            <li>L'accès non autorisé</li>
            <li>La modification non autorisée</li>
            <li>La divulgation non autorisée</li>
            <li>La destruction non autorisée</li>
          </ul>
          <p class="mt-4">Ces mesures incluent le chiffrement, les pare-feu, les contrôles d'accès et les audits réguliers.</p>
        `
      },
      {
        title: '8. Vos droits',
        content: `
          <p>Conformément à la législation applicable, vous disposez des droits suivants concernant vos données personnelles :</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li><strong>Droit d'accès</strong> : obtenir une copie de vos données</li>
            <li><strong>Droit de rectification</strong> : corriger des données inexactes</li>
            <li><strong>Droit à l'effacement</strong> : demander la suppression de vos données</li>
            <li><strong>Droit à la limitation</strong> : restreindre le traitement de vos données</li>
            <li><strong>Droit à la portabilité</strong> : recevoir vos données dans un format structuré</li>
            <li><strong>Droit d'opposition</strong> : vous opposer au traitement de vos données</li>
            <li><strong>Droit de retrait du consentement</strong> : retirer votre consentement à tout moment</li>
          </ul>
          <p class="mt-4">Pour exercer ces droits, contactez-nous à : <a href="mailto:contact@zlotech.net" class="text-zlo-orange hover:underline">contact@zlotech.net</a></p>
        `
      },
      {
        title: '9. Cookies',
        content: `
          <p>Notre site utilise des cookies pour :</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li><strong>Cookies essentiels</strong> : nécessaires au fonctionnement du site</li>
            <li><strong>Cookies de préférences</strong> : mémoriser vos choix (langue, etc.)</li>
            <li><strong>Cookies analytiques</strong> : comprendre comment vous utilisez notre site</li>
          </ul>
          <p class="mt-4">Vous pouvez gérer vos préférences de cookies via les paramètres de votre navigateur.</p>
        `
      },
      {
        title: '10. Transferts internationaux',
        content: `
          <p>Vos données sont principalement traitées au Togo et dans l'espace CEDEAO. Si nous devons transférer vos données en dehors de cette zone, nous nous assurons que des garanties appropriées sont en place conformément à la législation applicable.</p>
        `
      },
      {
        title: '11. Modifications de la politique',
        content: `
          <p>Nous pouvons mettre à jour cette politique de confidentialité de temps à autre. Toute modification sera publiée sur cette page avec une date de mise à jour révisée. Nous vous encourageons à consulter régulièrement cette page.</p>
        `
      },
      {
        title: '12. Contact',
        content: `
          <p>Pour toute question concernant cette politique de confidentialité ou pour exercer vos droits, contactez-nous :</p>
          <ul class="list-disc ml-6 mt-2 space-y-1">
            <li>Email : <a href="mailto:contact@zlotech.net" class="text-zlo-orange hover:underline">contact@zlotech.net</a></li>
            <li>Adresse : Lomé, Togo</li>
            <li>Téléphone : +228 90 XX XX XX</li>
          </ul>
        `
      }
    ]
  } : {
    title: 'Privacy Policy',
    lastUpdate: 'Last updated: February 2026',
    sections: [
      {
        title: '1. Introduction',
        content: `
          <p>ZLO Technologies is committed to protecting the privacy of users of its website. This privacy policy explains how we collect, use, share and protect your personal information when you use our site.</p>
          <p class="mt-4">By using our site, you accept the practices described in this privacy policy.</p>
        `
      },
      {
        title: '2. Data Collected',
        content: `
          <p>We collect the following types of information:</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li><strong>Contact information</strong>: name, email address, phone number when you fill out our contact form</li>
            <li><strong>Technical information</strong>: IP address, browser type, operating system, pages visited</li>
            <li><strong>Preferences</strong>: preferred language, cookie choices</li>
            <li><strong>Communications</strong>: content of messages you send us</li>
          </ul>
        `
      },
      {
        title: '3. Purposes of Processing',
        content: `
          <p>We use your personal data to:</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li>Respond to your requests and questions</li>
            <li>Provide the services you request</li>
            <li>Improve our site and services</li>
            <li>Send you information about our services (with your consent)</li>
            <li>Comply with our legal obligations</li>
            <li>Ensure site security</li>
          </ul>
        `
      },
      {
        title: '4. Legal Basis for Processing',
        content: `
          <p>We process your personal data on the following legal bases:</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li><strong>Consent</strong>: when you have explicitly agreed to the processing</li>
            <li><strong>Contract</strong>: when processing is necessary for the performance of a contract</li>
            <li><strong>Legal obligation</strong>: when we are required by law to process your data</li>
            <li><strong>Legitimate interest</strong>: to improve our services and ensure security</li>
          </ul>
        `
      },
      {
        title: '5. Data Retention',
        content: `
          <p>We keep your personal data only for as long as necessary for the purposes for which they were collected:</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li>Contact data: 3 years after last contact</li>
            <li>Cookie data: maximum 13 months</li>
            <li>Technical data: 1 year</li>
          </ul>
          <p class="mt-4">After these periods, your data is deleted or anonymized.</p>
        `
      },
      {
        title: '6. Data Sharing',
        content: `
          <p>We do not sell or rent your personal data to third parties. We may share your data with:</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li><strong>Service providers</strong>: hosting, maintenance, who act on our behalf</li>
            <li><strong>Legal authorities</strong>: when required by law</li>
          </ul>
          <p class="mt-4">All our providers are subject to confidentiality and security obligations.</p>
        `
      },
      {
        title: '7. Data Security',
        content: `
          <p>We implement appropriate technical and organizational security measures to protect your personal data against:</p>
          <ul class="list-disc ml-6 mt-2 space-y-1">
            <li>Unauthorized access</li>
            <li>Unauthorized modification</li>
            <li>Unauthorized disclosure</li>
            <li>Unauthorized destruction</li>
          </ul>
          <p class="mt-4">These measures include encryption, firewalls, access controls and regular audits.</p>
        `
      },
      {
        title: '8. Your Rights',
        content: `
          <p>In accordance with applicable legislation, you have the following rights regarding your personal data:</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li><strong>Right of access</strong>: obtain a copy of your data</li>
            <li><strong>Right to rectification</strong>: correct inaccurate data</li>
            <li><strong>Right to erasure</strong>: request deletion of your data</li>
            <li><strong>Right to restriction</strong>: restrict processing of your data</li>
            <li><strong>Right to portability</strong>: receive your data in a structured format</li>
            <li><strong>Right to object</strong>: object to processing of your data</li>
            <li><strong>Right to withdraw consent</strong>: withdraw your consent at any time</li>
          </ul>
          <p class="mt-4">To exercise these rights, contact us at: <a href="mailto:contact@zlotech.net" class="text-zlo-orange hover:underline">contact@zlotech.net</a></p>
        `
      },
      {
        title: '9. Cookies',
        content: `
          <p>Our site uses cookies for:</p>
          <ul class="list-disc ml-6 mt-2 space-y-2">
            <li><strong>Essential cookies</strong>: necessary for site operation</li>
            <li><strong>Preference cookies</strong>: remember your choices (language, etc.)</li>
            <li><strong>Analytical cookies</strong>: understand how you use our site</li>
          </ul>
          <p class="mt-4">You can manage your cookie preferences through your browser settings.</p>
        `
      },
      {
        title: '10. International Transfers',
        content: `
          <p>Your data is primarily processed in Togo and the ECOWAS region. If we need to transfer your data outside this zone, we ensure that appropriate safeguards are in place in accordance with applicable legislation.</p>
        `
      },
      {
        title: '11. Policy Changes',
        content: `
          <p>We may update this privacy policy from time to time. Any changes will be posted on this page with a revised update date. We encourage you to check this page regularly.</p>
        `
      },
      {
        title: '12. Contact',
        content: `
          <p>For any questions about this privacy policy or to exercise your rights, contact us:</p>
          <ul class="list-disc ml-6 mt-2 space-y-1">
            <li>Email: <a href="mailto:contact@zlotech.net" class="text-zlo-orange hover:underline">contact@zlotech.net</a></li>
            <li>Address: Lomé, Togo</li>
            <li>Phone: +228 90 XX XX XX</li>
          </ul>
        `
      }
    ]
  };

  return (
    <div className="min-h-screen bg-zlo-dark">
      {/* Header */}
      <header className="bg-zlo-dark border-b border-white/10 py-6">
        <div className="w-full px-6 lg:px-12 flex items-center gap-4">
          <button
            onClick={goBack}
            className="flex items-center gap-2 text-white/60 hover:text-white transition-colors"
          >
            <ArrowLeft className="w-5 h-5" />
            <span>{i18n.language === 'fr' ? 'Retour' : 'Back'}</span>
          </button>
        </div>
      </header>

      {/* Content */}
      <main className="w-full px-6 lg:px-12 py-12 max-w-4xl mx-auto">
        <div className="flex items-center gap-4 mb-8">
          <div className="w-12 h-12 rounded-xl bg-zlo-orange/20 flex items-center justify-center">
            <Shield className="w-6 h-6 text-zlo-orange" />
          </div>
          <div>
            <h1 className="heading-lg text-white">{content.title}</h1>
            <p className="text-zlo-text-secondary text-sm">{content.lastUpdate}</p>
          </div>
        </div>

        <div className="space-y-8">
          {content.sections.map((section, index) => (
            <section key={index} className="bg-white/5 border border-white/10 rounded-xl p-6">
              <h2 className="font-sora font-semibold text-xl text-white mb-4">
                {section.title}
              </h2>
              <div 
                className="text-zlo-text-secondary leading-relaxed"
                dangerouslySetInnerHTML={{ __html: section.content }}
              />
            </section>
          ))}
        </div>

        {/* Footer */}
        <footer className="mt-12 pt-8 border-t border-white/10 text-center">
          <p className="text-zlo-text-secondary text-sm">
            © 2026 ZLO Technologies — {i18n.language === 'fr' ? 'Tous droits réservés' : 'All rights reserved'}
          </p>
        </footer>
      </main>
    </div>
  );
};

export default PrivacyPage;
